
/**
 ******************************************************************************
 *
 * @file        RingBuffer.c
 * @brief       Ring Buffer routine.
 *
 * @par         Project
 *              MG32x02z
 * @version     V1.01
 * @date        2021/05/31
 * @author      Megawin Software Center
 * @copyright   Copyright (c) 2017 MegaWin Technology Co., Ltd.
 *              All rights reserved.
 *
 ******************************************************************************* 
 * @par Disclaimer
 * The Demo software is provided "AS IS" without any warranty, either
 * expressed or implied, including, but not limited to, the implied warranties
 * of merchantability and fitness for a particular purpose. The author will
 * not be liable for any special, incidental, consequential or indirect
 * damages due to loss of data or any other reason.
 * These statements agree with the world wide and local dictated laws about
 * authorship and violence against these laws.
 *******************************************************************************
 *******************************************************************************
 */


/* Includes ------------------------------------------------------------------*/
#include "RingBuffer.h"
#include "Utils.h"

/* Wizard menu ---------------------------------------------------------------*/
/* Private typedef -----------------------------------------------------------*/
/* Private define ------------------------------------------------------------*/
/* Private macro -------------------------------------------------------------*/
/* Private variables ---------------------------------------------------------*/
/* Private function prototypes -----------------------------------------------*/
/* Exported variables --------------------------------------------------------*/
__IO uint32_t gIdleCount;

/* Exported functions --------------------------------------------------------*/
/* External vairables --------------------------------------------------------*/

/**
 *******************************************************************************
 * @brief       
 * @details     
 * @return      
 * @exception   No
 * @note
 * @par         Example
 * @code
 * @endcode
 *******************************************************************************
 */
void RingBufferU8_Initial(RingBufferU8* pRing, uint8_t* pStorage, uint16_t Size)
{
    pRing->Storage = pStorage;
    pRing->Size = Size;
    pRing->End = pRing->Storage + pRing->Size;
    pRing->Read = pRing->Storage;
    pRing->Write = pRing->Storage;
    pRing->Available = 0;
}

/**
 *******************************************************************************
 * @brief       
 * @details     
 * @return      
 * @exception   No
 * @note
 * @par         Example
 * @code
 * @endcode
 *******************************************************************************
 */
uint16_t RingBufferU8_Free(RingBufferU8* pRing)
{
    return pRing->Size - pRing->Available;
}

/**
 *******************************************************************************
 * @brief       
 * @details     
 * @return      
 * @exception   No
 * @note
 * @par         Example
 * @code
 * @endcode
 *******************************************************************************
 */
uint16_t RingBufferU8_Available(RingBufferU8* pRing)
{
    return pRing->Available;
}

/**
 *******************************************************************************
 * @brief       
 * @details     
 * @return      
 * @exception   No
 * @note
 * @par         Example
 * @code
 * @endcode
 *******************************************************************************
 */
void RingBufferU8_Clear(RingBufferU8* pRing)
{
    pRing->Read = pRing->Storage;
    pRing->Write = pRing->Storage;
    pRing->Available = 0;
}

/**
 *******************************************************************************
 * @brief       
 * @details     
 * @return      
 * @exception   No
 * @note
 * @par         Example
 * @code
 * @endcode
 *******************************************************************************
 */
void RingBufferU8_WriteByte(RingBufferU8* pRing, uint8_t Data)
{
    if (pRing->Available >= pRing->Size)
        RingBufferU8_ReadByte(pRing);

    *pRing->Write = Data;
    pRing->Write++;
    pRing->Available++;

    if (pRing->Write >= pRing->End)
        pRing->Write = pRing->Storage;
}

/**
 *******************************************************************************
 * @brief       
 * @details     
 * @return      
 * @exception   No
 * @note
 * @par         Example
 * @code
 * @endcode
 *******************************************************************************
 */
void RingBufferU8_Write(RingBufferU8* pRing, const uint8_t* pBuffer, uint16_t Size)
{
    uint16_t lCount;

    // TODO can be optimized
    for (lCount = 0; lCount < Size; lCount++)
        RingBufferU8_WriteByte(pRing, pBuffer[lCount]);
}

/**
 *******************************************************************************
 * @brief       
 * @details     
 * @return      
 * @exception   No
 * @note
 * @par         Example
 * @code
 * @endcode
 *******************************************************************************
 */
uint8_t RingBufferU8_ReadByte(RingBufferU8* pRing)
{
    uint8_t lReturn;
    
    if (pRing->Available == 0) {
        return 0;
    }

    lReturn = *pRing->Read++;
    
    pRing->Available--;

    if (pRing->Read >= pRing->End)
        pRing->Read = pRing->Storage;
    return lReturn;
}

/**
 *******************************************************************************
 * @brief       
 * @details     
 * @return      
 * @exception   No
 * @note
 * @par         Example
 * @code
 * @endcode
 *******************************************************************************
 */
void RingBufferU8_Read(RingBufferU8* pRing, uint8_t* pBuffer, uint16_t Size)
{
    uint16_t lCount;

    // TODO can be optimized
    for (lCount = 0; lCount < Size; lCount++)
        pBuffer[lCount] = RingBufferU8_ReadByte(pRing);
}

/**
 *******************************************************************************
 * @brief       
 * @details     
 * @return      
 * @exception   No
 * @note
 * @par         Example
 * @code
 * @endcode
 *******************************************************************************
 */
uint8_t RingBufferU8_Peekn(RingBufferU8* pRing, uint16_t i)
{
    __I uint8_t* lpRead;
    __I uint8_t* lp;
    
    if (i >= pRing->Available)
        return 0;
    
    
    lpRead = pRing->Read;
    lp = lpRead + i;
    
    if (lp >= pRing->End)
        lp -= pRing->Size;
    return *lp;
    
}

/**
 *******************************************************************************
 * @brief       
 * @details     
 * @return      
 * @exception   No
 * @note
 * @par         Example
 * @code
 * @endcode
 *******************************************************************************
 */
uint8_t RingBufferU8_Peek(RingBufferU8* pRing)
{
    return RingBufferU8_Peekn(pRing, 0);
}

/**
 *******************************************************************************
 * @brief       
 * @details     
 * @return      
 * @exception   No
 * @note
 * @par         Example
 * @code
 * @endcode
 *******************************************************************************
 */
uint16_t RingBufferU8_ReadUntil(RingBufferU8* pRing, char* pBuffer, uint16_t Size, uint8_t StopByte)
{
    uint8_t lTempU8;
    uint16_t lCount;
    for (lCount = 0; lCount < min(pRing->Available, Size - 1); lCount++)
    {
        lTempU8 = RingBufferU8_Peekn(pRing, lCount);

        if (lTempU8 == StopByte)
        {
            lCount++;
            RingBufferU8_Read(pRing, (uint8_t*) pBuffer, lCount);
            pBuffer[lCount] = '\0';
            return lCount;
        }
    }
    pBuffer[0] = '\0';
    return 0;
}

/**
 *******************************************************************************
 * @brief       
 * @details     
 * @return      
 * @exception   No
 * @note
 * @par         Example
 * @code
 * @endcode
 *******************************************************************************
 */
uint16_t RingBufferU8_ReadLine(RingBufferU8* pRing, char* pBuffer, uint16_t Size)
{
    return RingBufferU8_ReadUntil(pRing, pBuffer, Size, '\r');
}


